import json
from utils.base import APIView, get_offset_count
from utils.logger import error_logger


class TopicHomeRecommendList(APIView):

    def get(self, request):

        sort_ = request.GET.get('sort_params', '-topic_id')
        offset, count = get_offset_count(request)

        try:
            data = self.rpc['venus/sun/operation/topic_recommend/list'](sort_=sort_, offset=offset,
                                                                        count=count).unwrap()
        except Exception as e:
            error_logger.error(u'获取首页推荐帖子列表失败%s', e)
            raise

        return data


class TopicHomeRecommendEdit(APIView):

    def post(self, request):
        
        id_ = request.POST.get('id')
        is_online = request.POST.get("is_online")
        rank = request.POST.get("rank")

        data = {}
        if is_online is not None:
            data["is_online"] = int(is_online)

        if rank is not None:
            data["rank"] = int(rank)

        if not data and not id_:
            return {'message': '参数不全'}

        try:
            self.rpc['venus/sun/operation/topic_recommend/edit'](id_=id_, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'更新失败', e)
            raise

        return {
            'message': '更新成功'
        }


class TopicHomeFixOperation(APIView):

    def get(self, request):

        try:
            pos = request.GET.get("pos", 4)
            data = self.rpc['venus/sun/operation/home_fix/info'](pos=pos).unwrap()
        except Exception as e:
            error_logger.error(u'运营位获取失败%s', e)
            raise

        return {'data': data}

    def post(self, request):

        image = request.POST.get('image')
        protocol = request.POST.get("protocol")
        pos = request.POST.get("pos", 4)

        if not image or not protocol:
            return {'message': '参数不全'}

        try:
            self.rpc['venus/sun/operation/home_fix/edit'](image=image, protocol=protocol, pos=pos).unwrap()
        except Exception as e:
            error_logger.error(u'更新失败', e)
            raise

        return {
            'message': '更新成功'
        }


class PictorialHomeRecommendList(APIView):
    """获取画报首页运营位推荐画报列表"""

    def get(self, request):
        offset, count = get_offset_count(request)
        filters = json.loads(request.GET.get('filters', '{}'))
        sort_by  = request.GET.get('sort_by', None)

        try:
            data = self.rpc['venus/sun/operation/recommend/pictorial/list'](filters=filters, sort_by=sort_by, offset=offset, count=count).unwrap()
        except Exception as e:
            error_logger.error(u'获取数据失败', e)
            raise

        return data


class PictorialHomeRecommendUpdate(APIView):
    """更新画报首页运营位推荐画报"""

    def post(self, request):
        pictorial_id = request.POST.get('id')
        rank = request.POST.get('rank')

        try:
            if rank:
                data = self.rpc['venus/sun/operation/recommend/pictorial/rank'](pictorial_id=pictorial_id, rank=rank).unwrap()
            elif pictorial_id:
                data = self.rpc['venus/sun/operation/recommend/pictorial/delete'](pictorial_id=pictorial_id).unwrap() 
        except Exception as e:
            error_logger.error(u'操作失败', e)
            raise

        if not data:
            return u'操作失败'

        return data


class OperationDelete(APIView):
    """删除运营位"""

    def post(self, request):
        operation_id = request.POST.get('id')

        try:
            data = self.rpc['venus/sun/operation/delete'](id_=operation_id).unwrap()
        except Exception as e:
            error_logger.error(u'操作失败', e)
            raise

        if not data:
            return u'操作失败'

        return data


class OperationEdit(APIView):
    """编辑运营位"""

    def post(self, request):

        operation_id = request.POST.get('id')
        operation_type = int(request.POST.get('operation_type'))
        image_url = request.POST.get('image_url')
        url = request.POST.get('url')
        start_time = int(request.POST.get('start_time'))
        end_time = int(request.POST.get('end_time'))

        data = {
            "operation_type": operation_type,
            "image_url": image_url,
            "url": url,
            "start_time": start_time,
            "end_time": end_time
        }

        try:
            data = self.rpc['venus/sun/operation/edit'](id_=operation_id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'操作失败', e)
            raise

        if not data:
            return u'操作失败'

        return data


class OperationList(APIView):
    """获取运营位列表"""

    def get(self, request):
        operation_type = request.GET.get('operation_type')

        try:
            data = self.rpc['venus/sun/operation/list'](operation_type=operation_type).unwrap()
        except Exception as e:
            error_logger.error(u'获取失败', e)
            raise

        return data
