import json
from utils.base import APIView
from utils.logger import error_logger


class PictorialListView(APIView):
    def get(self, request):
        star_id = request.GET.get('star_id')
        user_id = request.GET.get('user_id')
        offset = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filters = self.handle_filter(request.GET.get('filter', '{}'))
        if star_id:
            filters.update({'star_id': star_id})
        if user_id:
            filters.update({'user_id': user_id})
        try:
            data = self.rpc['venus/sun/pictorial/list'](filters=filters, offset=(offset-1)*limit, limit=limit).unwrap()
        except Exception as e:
            error_logger.error(u'获取画报列表失败%s' , e)
            raise
        return data

    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        updates = json.loads(request.POST.get('update', '{}'))
        try:
            self.rpc['venus/sun/pictorial/batch/update'](updates=updates, ids=ids).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新失败%s', e)
            raise
        return {
            "message": "更新成功"
        }


class PictorialUpdateOrCreate(APIView):
    def get(self, request):
        id = request.GET.get('id').split(':')[0]
        try:
            data = self.rpc['venus/sun/pictorial/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取%s画报信息失败%s'%(id, e))
            raise
        return data

    def post(self, request):
        id = request.POST.get('id')
        star_ids = json.loads(request.POST.get('star', '[]'))
        pictorial_user_ids = json.loads(request.POST.get('pictorial_user_ids', '[]'))
        collection_tag_ids = json.loads(request.POST.get('collection_tag_ids', '[]'))
        data = {
            'name': request.POST.get('name', ''),
            'description': request.POST.get('description', ''),
            'creator_id': request.POST.get('creator_id', ''),
            'celebrity_ids': star_ids,
            'is_online': int(request.POST.get('is_online', 1)),
            'is_recommend': int(request.POST.get('is_recommend', 0)),
            'pictorial_user_ids': pictorial_user_ids,
            'icon': request.POST.get('icon', ''),
            'collection_tag_ids': collection_tag_ids,
            'is_home_recommend': int(request.POST.get('is_home_recommend', 0)),
        }
        try:
            data = self.rpc['venus/sun/pictorial/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'编辑%s用户信息失败%s' % (id, e))
            raise
        if not data.get('id'):
            return {
                'message': '画报已存在'
            }
        return {
            'message': '更新成功',
            'data': data
        }

    
class PictorialTopics(APIView):
    """多个帖子关系"""

    def post(self, request):
        topic_ids = json.loads(request.POST.get('topic_ids', '[]'))
        pictorial_id = request.POST.get('pictorial_id')

        try:
            self.rpc['venus/sun/pictorial/add_topics'](topic_ids=topic_ids, pictorial_id=pictorial_id).unwrap()
        except Exception as e:
            error_logger.error(u'编辑%s用户信息失败%s' % (id, e))
            raise
        return {
            'message': '更新成功'
        }
