/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.ChannelReader;
import com.meituan.android.walle.PayloadWriter;
import com.meituan.android.walle.SignatureNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class ChannelWriter {
    private ChannelWriter() {
    }

    public static void put(File apkFile, String channel) throws IOException, SignatureNotFoundException {
        ChannelWriter.put(apkFile, channel, false);
    }

    public static void put(File apkFile, String channel, boolean lowMemory) throws IOException, SignatureNotFoundException {
        ChannelWriter.put(apkFile, channel, null, lowMemory);
    }

    public static void put(File apkFile, String channel, Map<String, String> extraInfo) throws IOException, SignatureNotFoundException {
        ChannelWriter.put(apkFile, channel, extraInfo, false);
    }

    public static void put(File apkFile, String channel, Map<String, String> extraInfo, boolean lowMemory) throws IOException, SignatureNotFoundException {
        HashMap<String, String> newData = new HashMap<String, String>();
        Map<String, String> existsData = ChannelReader.getMap(apkFile);
        if (existsData != null) {
            newData.putAll(existsData);
        }
        if (extraInfo != null) {
            extraInfo.remove("channel");
            newData.putAll(extraInfo);
        }
        if (channel != null && channel.length() > 0) {
            newData.put("channel", channel);
        }
        JSONObject jsonObject = new JSONObject(newData);
        ChannelWriter.putRaw(apkFile, jsonObject.toString(), lowMemory);
    }

    public static void putRaw(File apkFile, String string) throws IOException, SignatureNotFoundException {
        ChannelWriter.putRaw(apkFile, string, false);
    }

    public static void putRaw(File apkFile, String string, boolean lowMemory) throws IOException, SignatureNotFoundException {
        PayloadWriter.put(apkFile, 0x71777777, string, lowMemory);
    }

    public static void remove(File apkFile) throws IOException, SignatureNotFoundException {
        ChannelWriter.remove(apkFile, false);
    }

    public static void remove(File apkFile, boolean lowMemory) throws IOException, SignatureNotFoundException {
        PayloadWriter.remove(apkFile, 0x71777777, lowMemory);
    }
}

